/***************************************************************************************
* TESTBENCH FOR RevA DC2071 added SOS bit
* December 2013
***************************************************************************************/
`timescale 1ps/1ps

module reva_testbench();


RevA tb (
   .CSB_33		(CSB_33),
	.CLK			(CLK),
	.CLKOUT		(CLKOUT),
	.SDO			(SDO),
	.SCK_33		(SCK_33),
	.BUSY_33		(BUSY_33),
	.DB2			(DB2),
	.DB3			(DB3),
	.DB4			(DB4),
	.DB5			(DB5),
	.DB6			(DB6),
	.DB7			(DB7),
	.DB8			(DB8),
	.DB9			(DB9),
	.DB10			(DB10),
	.DB14			(DB14),
	.DB15			(DB15),
	.DB16			(DB16),
	.DB17			(DB17),
	.DB0			(DB0),
	.DB1			(DB1),
	.DB11			(DB11),
	.DB12			(DB12),
	.DB13			(DB13),
	.WRIN			(WRIN),
	.B16_18L		(B16_18L),
	.SCK_IN		(SCK_IN),
	.SCK_OUT		(SCK_OUT),
	.SDI_33		(SDI_33),
	.SDIIN		(SDIIN),
	.SCKIN		(SCKIN),
	.CNVIN		(CNVIN),
	.ID			(ID),
	.SOS		(SOS),
	.A3			(A3),
	.A2			(A2),
	.A1			(A1),
	.A0			(A0),
	.R1			(R1),
	.R0			(R0),
	.SEL			(SEL),
	.d_latch_out		(d_latch_out),
	.master_clk_out	(master_clk_out),
	.master_clkd_out	(master_clkd_out)
	);

 reg [155:0] data;
 reg [155:0] data2;
 reg [155:0] data3;
 reg SDOIN;
 reg BUSY_33IN;
 reg CLKIN;
 reg WRININ;
 assign CLK=CLKIN;
 assign SDO=SDOIN;
 assign BUSY_33=BUSY_33IN;
 assign ID=0;
 assign WRIN=WRININ;
 assign B16_18L=0;
/* Generating the SPI Master Clock */ 
  
initial 
begin
      CLKIN <= 1'b0;
		//           1        10        20        30        40        50        60        70     77 80        90        100       110       120       130       140       150
       data = 156'b000000000000000000000000000000000000000000000000000001011011101111011111000000000000000000000000000000000000000000000000000000000000101101110111101111000000;     	// sdo data
   	data2 = 156'b000111111111111111111111111111111111111111111111110000000000000000000000000000001111111111111111111111111111111111111111111111111000000000000000000000000000;	  		// busy data
		data3 = 156'b111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;     	// WRIN data
end

 always #50000 CLKIN = ~CLKIN;
 
 



always @(negedge CLKIN) begin 
 SDOIN <= data[155];
 data <= {data[154:0],data[155]}; 
 BUSY_33IN <= data2[155];
 data2 <= {data2[154:0],data2[155]};
 WRININ <= data3[155];
 data3 <= {data3[154:0],data3[155]};
   
end
 
    
endmodule